<?php

class ControllerExtensionPaymentVtb extends Controller {
    public function index() {
        $this->load->language('/extension/payment/vtb');
        
        $data['vtb_template'] = 'confirm';
        $data['button_confirm'] = $this->language->get('button_confirm');
        
        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . 'extension/payment/vtb')) {
            return $this->load->view($this->config->get('config_template') . 'extension/payment/vtb', $data);
        } else {
            return $this->load->view('extension/payment/vtb', $data);
        }
    }

 
    public function register() {
        if (!empty($this->session->data['order_id'])) {
            $this->load->model('checkout/order');
            $orderInfo = $this->model_checkout_order->getOrder($this->session->data['order_id']);

            $this->model_checkout_order->addOrderHistory($orderInfo['order_id'], $this->config->get('config_order_status_id'));

            $this->load->model('extension/payment/vtb');

            $arDelivery = array();
            if ($this->cart->hasShipping()) {
                foreach ($this->cart->getProducts() as $product) {
                    $arDelivery['tax_class_id'] = $product['tax_class_id'];
                }
                $arDelivery['shipping_cost'] = $this->session->data['shipping_method']['cost'];
                foreach ($this->tax->getRates($arDelivery['shipping_cost'], $arDelivery['tax_class_id']) as $shipping_tax) {
                    $arDelivery['shipping_tax_amount'] = $shipping_tax['amount']; 
                }
                $arDelivery['shipping_percentage'] = $arDelivery['shipping_tax_amount'] / $arDelivery['shipping_cost'] * 100;
                $arDelivery['full_shipping_cost'] = $arDelivery['shipping_cost'] + $arDelivery['shipping_tax_amount'];
            } else {
                $arDelivery['full_shipping_cost'] = 0;
            }

            $cartItems = array();
            foreach ($this->cart->getProducts() as $product) { 
                $item = array();
                $item['name'] = $product['name'];
                $item['quantity'] = $product['quantity'];
                $item['tax_class_id'] = $product['tax_class_id'];
                $item['price'] = $product['price'];
                foreach ($this->tax->getRates($item['price'], $item['tax_class_id']) as $tax) {
                    $item['tax_amount'] = $tax['amount'];
                }
                $item['full_price'] = $item['price'] + $item['tax_amount'];
                $item['percentage'] = $item['tax_amount'] / $item['price'] * 100;
                $cartItems[] = $item; 
            }
            
            $soapClient = $this->model_extension_payment_vtb->newSoap($this->config->get('vtb_shop_url'), $this->config->get('vtb_shop_login'), $this->config->get('vtb_shop_password'));
            $request = $this->model_extension_payment_vtb->prepareOrder($this->config->get('vtb_shop_id'), $orderInfo['order_id'], number_format($orderInfo['total'], 2, '.', ''), $orderInfo['customer_id'], $orderInfo['payment_lastname'] . ' ' . $orderInfo['payment_firstname'], $orderInfo['email'], $orderInfo['telephone'], $this->url->link('extension/payment/vtb/status_ok'), $this->url->link('extension/payment/vtb/status_fault'), $cartItems, $arDelivery);
            try {
                $info = $soapClient->register($request);
                $this->response->redirect($info->redirect_url . '?session=' . $info->session);
            } catch (SoapFault $fault) {
                $this->load->language('extension/payment/vtb');

                $data['vtb_template'] = 'try_again';
                $data['button_try_again'] = $this->language->get('button_try_again');
                $data['error_register_fault'] = $this->language->get('error_register_fault');
                $data['error_register_fault_code'] = $fault->faultstring;

                return $this->_render($data);
            }
        } else {
            $this->response->redirect('/');
        }
    }


    public function status_ok() {
        if (!empty($this->session->data['order_id'])) {
            $this->load->language('extension/payment/vtb');
            $data = array();

            $this->load->model('checkout/order');
            $orderInfo = $this->model_checkout_order->getOrder($this->session->data['order_id']);

            $this->load->model('extension/payment/vtb');
            $soapClient = $this->model_extension_payment_vtb->newSoap($this->config->get('vtb_shop_url'), $this->config->get('vtb_shop_login'), $this->config->get('vtb_shop_password'));
            $objStatus = $this->model_extension_payment_vtb->getOrderStatus($this->config->get('vtb_shop_id'), $orderInfo['order_id']);
            try {
                $info = $soapClient->get_status($objStatus);

                switch ($info->status) {
                    case 'acknowledged':
                    case 'not_acknowledged':
                    case 'authorized':
                        $this->model_checkout_order->addOrderHistory($orderInfo['order_id'], $this->config->get('vtb_order_status_success_id'), 'vtb status: ' . $info->status, false);
                        $this->response->redirect($this->url->link('checkout/success'));
                    break;

                    case 'canceled':
                    case 'not_authorized':
                        $this->model_checkout_order->addOrderHistory($orderInfo['order_id'], $this->config->get('vtb_order_status_fail_id'), 'vtb status: ' . $info->status, false);
                        $data['vtb_template'] = 'canceled';
                        $data['error_canceled'] = $this->language->get('error_canceled');
                    break;

                    default:
                        $data['vtb_template'] = 'process';
                        $data['error_process'] = $this->language->get('error_process');
                        $data['button_finish'] = $this->language->get('button_finish');
                        $data['button_finish_url'] = $this->url->link('checkout/success');
                    break;
                }

            } catch (SoapFault $fault) {
                if ($fault->faultstring === 'INVALID_ORDER') {
                    $this->model_checkout_order->addOrderHistory($orderInfo['order_id'], $this->config->get('vtb_order_status_fail_id'), 'vtb status: ' . $info->status, false);
                    $data['vtb_template'] = 'invalid_order';
                    $data['error_invalid_order'] = $this->language->get('error_invalid_order');
                }
            }

            return $this->_render($data);
        }
    }


    public function status_fault() {
        $this->load->language('extension/payment/vtb');

        $data['vtb_template'] = 'status_fault';
        $data['button_try_again'] = $this->language->get('button_try_again');
        $data['error_status_fault'] = $this->language->get('error_status_fault');

        $this->load->model('checkout/order');
        $orderInfo = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        $this->model_checkout_order->addOrderHistory($orderInfo['order_id'], $this->config->get('vtb_order_status_fail_id'), 'vtb status: Canceled', false);

        return $this->_render($data);
    }


    function _render($data) {
        $data['heading_title'] = $this->language->get('heading_title');
        $data['heading_payment'] = $this->language->get('heading_payment');
        $data['text_back'] = $this->language->get('text_back');
        $data['text_continue'] = $this->language->get('text_continue');
        $data['error_payment_method'] = $this->language->get('error_payment_method');

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . 'extension/payment/vtb')) {
            $this->response->setOutput($this->load->view($this->config->get('config_template') . 'extension/payment/vtb', $data));
        } else {
            $this->response->setOutput($this->load->view('extension/payment/vtb', $data));
        }
    }


    public function cron() {
        $this->load->model('extension/payment/vtb');
        $this->model_extension_payment_vtb->updateOrdersStatuses();
    }

}
?>
